import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.*;
import javax.swing.UIManager;

// Referenced classes of package duggelz.jape:
//            BasicStructure, DataChangeListener, ItemPanel, JapeAbout,
//            SaveGame, StatPanel, Actor,
//            Mercenary, DataChangeEvent

public class JapeFrame extends Frame implements DataChangeListener {

    public JapeFrame() {
        super("JAPE - Jagged Alliance 2 Savegame Editor");
        feld = this;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {}
        layout = new GridBagLayout();
        currentDir = System.getProperty("user.dir");
        createMenuBar();
        Panel body = new Panel();
        body.setLayout(layout);
        add("Center", body);
        actorList = new List();
        actorList.addItemListener(new ItemListener() {

            public void itemStateChanged(ItemEvent e) {
                doSelectActor();
            }

        });
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weighty = 1.0D;
        c1.weightx = 0.0D;
        body.add(actorList, c1);
        statPanel = new StatPanel(this);
        statPanel.addDataChangeListener(this);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.anchor = 18;
        c2.gridx = 1;
        c2.gridy = 0;
        c2.weighty = 1.0D;
        c2.weightx = 1.0D;
        body.add(statPanel, c2);
        itemPanel = new ItemPanel(this);
        itemPanel.addDataChangeListener(this);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.fill = 1;
        c3.anchor = 18;
        c3.gridx = 2;
        c3.gridy = 0;
        c3.weighty = 1.0D;
        c3.weightx = 1.0D;
        body.add(itemPanel, c3);
        addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent e) {
                doQuit();
            }

        });
        addNotify();
        populateActorList();
        pack();
        repaint();
    }

    private void createMenuBar() {
        menuBar = new MenuBar();
        fileMenu = new Menu("Datei");
        menuBar.add(fileMenu);
        openItem = new MenuItem("Laden..");
        openItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                doOpen();
            }

        });
        fileMenu.add(openItem);
        openAgainItem = new MenuItem("Erneut ffnen");
        openAgainItem.setEnabled(false);
        openAgainItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (saveGame.filename != null) {
                    OpenGame(saveGame.filename);
                }
            }

        }
        );
        fileMenu.add(openAgainItem);
        saveItem = new MenuItem("Speichern");
        saveItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                doSave();
            }

        });
        fileMenu.add(saveItem);
        saveItem.setEnabled(false);
        closeItem = new MenuItem("Schlieen");
        closeItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                doClose();
            }

        });
        fileMenu.add(closeItem);
        closeItem.setEnabled(false);
        fileMenu.addSeparator();
        quitItem = new MenuItem("Beenden");
        quitItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                doQuit();
            }

        });
        fileMenu.add(quitItem);
        helpMenu = new Menu("Hilfe");
        menuBar.add(helpMenu);
        menuBar.setHelpMenu(helpMenu);
        aboutItem = new MenuItem("ber...");
        helpMenu.add(aboutItem);
        aboutItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String Nachricht =
                        "JAPE: A Jagged Alliance 2 Save Game Editor\n" +
                        "Version 0.33\n" +
                        "Copyright (c) 1999  Douglas Greiman\n" +
                        "Deutsche Portierung (c) 2005 von Bernd Leitenberger\n";
                JOptionPane.showMessageDialog(null, Nachricht, "Info ber Jape",
                                              JOptionPane.INFORMATION_MESSAGE);
            }

        });
        setMenuBar(menuBar);
    }

    public void dataChanged(DataChangeEvent event) {
        saveGameModified = true;
    }


    public boolean doClose() {
        if (saveGame != null && saveGameModified) {
            String shortName = (new File(saveGame.filename)).getName();
            int option = JOptionPane.showConfirmDialog(this,
                    "Die Datei " + shortName + " wurde verndert.\n" +
                    "Wollen Sie die nderungen speichern ?", getTitle(),
                    JOptionPane.YES_NO_CANCEL_OPTION,
                         JOptionPane.QUESTION_MESSAGE);
            if (option == JOptionPane.CANCEL_OPTION) {
                return false;
            }
            if (option == JOptionPane.YES_OPTION) {
                boolean success = doSave();
                if (!success) {
                    return false;
                }
            }
        }
        saveItem.setEnabled(false);
        closeItem.setEnabled(false);
        openAgainItem.setEnabled(false);
        saveGame = null;
        saveGameModified = false;
        populateActorList();
        return true;
    }

    private boolean OpenGame(String filename) {
        SaveGame saveGame = new SaveGame();
        try {
            saveGame.load(filename);
        } catch (EOFException _ex) {
            JOptionPane.showMessageDialog(this,
                    "Kann Datei nicht laden.\nUnerwartet Dateiende erreicht.",
                                          getTitle(), 0);
            return false;
        } catch (FileNotFoundException _ex) {
            JOptionPane.showMessageDialog(this,
                    "Kann Datei nicht laden.\nDatei kann nicht gefunden oder geladen werden",
                                          getTitle(), 0);
            return false;
        } catch (IOException e) {
            String errorMessage = e.getMessage();
            if (e.getMessage() == null) {
                errorMessage =
                        "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this,
                                          "Kann Datei nicht laden.\n" + errorMessage,
                                          getTitle(), 0);
            return false;
        } catch (SaveGame.FormatException _ex) {
            JOptionPane.showMessageDialog(this,
                    "Kann Datei nicht laden.\nDas Spielformat ist unbekannt.",
                                           getTitle(), 0);
            return false;
        }
        saveItem.setEnabled(true);
        closeItem.setEnabled(true);
        openAgainItem.setEnabled(true);
        this.saveGame = saveGame;
        populateActorList();
        actorList.select(0);
        doSelectActor();
        saveGameModified = false;
        return true;

    }

    public boolean doOpen() {
        boolean success = doClose();
        if (!success) {
            return false;
        }
        FileDialog fileDialog = new FileDialog(this, "ffnen", 0);
        if (currentDir != null) {
            fileDialog.setDirectory(currentDir);
        }
        fileDialog.setFile("*.sav");
        fileDialog.show();
        String directory = fileDialog.getDirectory();
        String name = fileDialog.getFile();
        if (name == null) {
            return false;
        }
        currentDir = directory;
        String filename = (new File(directory, name)).toString();
        OpenGame(filename);
        return true;
    }

    public boolean doQuit() {
        boolean success = doClose();
        if (!success) {
            return false;
        } else {
            setVisible(false);
            dispose();
            System.exit(0);
            return true;
        }
    }

    public boolean doSave() {
        if (saveGame == null) {
            return true;
        }
        try {
            saveGame.save();
        } catch (IOException e) {
            String errorMessage = e.getMessage();
            if (e.getMessage() == null) {
                errorMessage =
                        "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this,
                                           "Kann die Datei nicht speichern.\n" +
                                           errorMessage, getTitle(), 0);
            return false;
        }
        saveGameModified = false;
        statPanel.setModified(false);
        itemPanel.setModified(false);
        return true;
    }

    private boolean doSelectActor() {
        int idx = actorList.getSelectedIndex();
        Actor actor = null;
        Mercenary merc = null;
        if (idx != -1) {
            actor = saveGame.getActor(idx);
            String nickname = actor.get("Nickname");
            merc = saveGame.getMercByNick(nickname);
        }
        doSetActor(actor, merc);
        return true;
    }

    private void doSetActor(Actor actor, Mercenary merc) {
        currentActor = actor;
        currentMerc = merc;
        statPanel.setActor(currentActor, currentMerc);
        itemPanel.setActor(currentActor, currentMerc);
    }

    public static void main(String args[]) {
        JapeFrame japeFrame = new JapeFrame();
        japeFrame.show();
    }

    private void populateActorList() {
        actorList.removeAll();
        doSetActor(null, null);
        if (saveGame == null) {
            return;
        }
        for (int idx = 0; idx < saveGame.actorCount; idx++) {
            Actor actor = saveGame.getActor(idx);
            String nickname = actor.get("Nickname");
            Mercenary merc = saveGame.getMercByNick(nickname);
            if (merc != null) {
                nickname = "*" + nickname;
            }
            actorList.add(nickname);
        }

    }

    public static void setcaption(String caption) {
        feld.setTitle(caption);
    }

    private static final int DEFAULT_WIDTH = 450;
    private static final int DEFAULT_HEIGHT = 450;
    private GridBagLayout layout;
    private List actorList;
    private StatPanel statPanel;
    private ItemPanel itemPanel;
    private MenuBar menuBar;
    private Menu fileMenu;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem closeItem;
    private MenuItem quitItem;
    private MenuItem openAgainItem;
    private Menu helpMenu;
    private MenuItem aboutItem;
    private SaveGame saveGame;
    private boolean saveGameModified;
    private Actor currentActor;
    private Mercenary currentMerc;
    private String currentDir;
    private static Frame feld;

}
